#ifndef SIMPLESERIAL_ANALYZER_SETTINGS
#define SIMPLESERIAL_ANALYZER_SETTINGS

#include <AnalyzerSettings.h>
#include <AnalyzerTypes.h>

#define DISPLAY_MODE_RAW_BITS		0
#define DISPLAY_MODE_BYTES			1
#define DISPLAY_MODE_WORDS			2
#define DISPLAY_MODE_TRANSACTIONS	3

class SimpleSerialAnalyzerSettings : public AnalyzerSettings
{
public:
	SimpleSerialAnalyzerSettings();
	virtual ~SimpleSerialAnalyzerSettings();

	virtual bool SetSettingsFromInterfaces();
	void UpdateInterfacesFromSettings();
	virtual void LoadSettings( const char* settings );
	virtual const char* SaveSettings();

	
	Channel mChannelPin1;
	Channel mChannelPin5;
	int mDisplayMode;

protected:
	std::auto_ptr< AnalyzerSettingInterfaceChannel >	mChannelPin1Iface;
	std::auto_ptr< AnalyzerSettingInterfaceChannel >	mChannelPin5Iface;
	std::auto_ptr< AnalyzerSettingInterfaceNumberList >	mDisplayModeIface;

private:
	void ClaimChannels(void);
};

#endif //SIMPLESERIAL_ANALYZER_SETTINGS
